//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Force Unwrapping
//:
//: ⚠️ Force unwrapping is dangerous and should be avoided.
//:
//: The `!` operator is used to unwrap an optional without first checking if a value exists.
//:
//: This is dangerous.
//:
/*:
 
 */
//: If a value doesn't exist then no associated value can be extracted and the application terminates (from receiving un-executable instructions). 💥
//:
//: -------------------
//:


// works when we have a value
var wrappedInteger: Int? = 56
let forceUnwrappedInteger: Int = wrappedInteger!
print(forceUnwrappedInteger)

// explodes when we don't have a value
wrappedInteger = nil
let forceUnwrappedInteger2 = wrappedInteger! // 💥
print(forceUnwrappedInteger2)


//:
//: -------------------
//:
//: ## Task:
//:
//: Create a new optional string. 
//:
//: Safely unwrap the optional and print it to the console.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: Using the optional you just declared, force unwrap the value and print its contents to the console.
//:
//: Execute your code when the string optional contains a value.
//:
//: Execute your code when the string optional contains `nil`.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: * callout(💡 Tip):
//:     → `!` is also known as the bang operator.
//:
//:     This is because if we're wrong and no value exists the entire application goes BANG and terminates! 💥
//:
//: -------------------
//:
//: ## 👷🏽👷‍♀️👷‍♂️🧑🏿‍💻👩🏽‍💻👨🏽‍💻
//: As a rule, good Swift engineers wont use the force unwrap operator within a commercial application. There may be some exceptions to this rule, but if you are looking to create a successful career building iOS apps then we recommend avoiding this operator in your code altogether.
//:
//: -------------------
//:
//: Let's think a bit more about this. If we imagine that our job is to build apps on the AppStore then the worst possible user experience is when the application terminates and suddenly disappears from sight - professionals avoid writing such code.
//:
//: 👉 Let's place a virtual bomb 💣 in our code by using the force unwrap operator.
//:
//: -------------------
//:


class Post {
    var liked: Bool = false
}
class SocialMediaFeed {
    func likeButtonPressed(forPost post: Post?) {
        post!.liked = true // 💣
    }
}

let feed = SocialMediaFeed()
let currentPost: Post? = nil // let's pretend the post is still loading

// ⛔️ Runtime error
feed.likeButtonPressed(forPost: currentPost) // 💥


//:
//: -------------------
//:
//: ## Task:
//:
//: If the code above was written for a commercial product the user would experience would be awful - a system crash!
//:
//: Finish the code below and safely unwrap the optional input parameter.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


extension SocialMediaFeed {
    func likeButtonPressed2(forPost post: Post?) {
        // TODO: safely unwrap the optional value
        post.liked = true
    }
}

// no runtime errors
feed.likeButtonPressed2(forPost: currentPost)

